% scrambling and encoding

%% Scrambler

if check_scrambling == 1

% length for PN sequence

nr_input_bits_PN = length(generated_input_before);

% load a stored PN sequence

load PN_Sequence.mat

% repeat the PN sequence until length is sufficient

while length(PN) < nr_input_bits_PN

    PN = [PN;PN];
    
end

% cut out the right PN sequence length

P = PN(1:length(generated_input_before));

% scramble the input

scrambled_bits = xor(generated_input_before, P');

else
    
    scrambled_bits = generated_input_before;
    
end

%% Hamming coding

if check_Hamming == 1
    
    nr_parity_bits = handles.nr_parity_bits;

% hamming code the data

[generated_input_hamming, added_number_zeros_hamming] = hamming_coding(scrambled_bits,nr_parity_bits);

else
    
    generated_input_hamming = scrambled_bits;
    nr_parity_bits = 0;
    added_number_zeros_hamming = 0;
    
end

% number of bits after hamming encoding

nr_bits_input = length(generated_input_hamming);

%% Interleaving 

if check_interleaving == 1

value_interleaving = get(handles.edit3,'Value');
options_for_interleaving = handles.options_for_interleaving;
nr_columns = options_for_interleaving(value_interleaving);
    
    
% Parameters for interleaving
nr_rows = nr_bits_input/nr_columns;

% Interleave the data
generated_input_hamming = interleaving(generated_input_hamming,nr_rows,nr_columns );
else
    
    nr_columns = 0;
    
end

